function mat=matrix(obj)
% MATRIX retourne la matrice de rflexion-rfraction d'une marche
%   d'nergie potentielle.
%   mat=MATRIX(obj)
%       >> obj  = objet informatique marche;
%       << mat  = matrice de rflexion-rfraction de l'objet informatique marche.
%
%   Olivier Pujol : septembre 2013
%
%% Vrifications

if (isa(obj,'marche')==0),error('Mauvais type d''objet !');end
%
if (obj.ke==0),error('Cas singulier k=0 !');end
if (obj.ks==0),error('Cas singulier k=0 !');end

%% Calcul de la matrice 

mat(1,1)=obj.ks+obj.ke;
mat(1,2)=obj.ks-obj.ke;
mat(2,1)=obj.ks-obj.ke;
mat(2,2)=obj.ks+obj.ke;
mat=(1/(2*sqrt(obj.ke*obj.ks))).*mat;
%
return;